/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers.data;

import java.util.Map;
import java.util.TreeMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import noppes.npcs.ICompatibilty;
import noppes.npcs.VersionCompatibility;
import noppes.npcs.api.CustomNPCsException;
import noppes.npcs.api.constants.OptionType;
import noppes.npcs.api.handler.data.IAvailability;
import noppes.npcs.api.handler.data.IDialog;
import noppes.npcs.api.handler.data.IDialogCategory;
import noppes.npcs.api.handler.data.IDialogOption;
import noppes.npcs.api.handler.data.IQuest;
import noppes.npcs.controllers.DialogController;
import noppes.npcs.controllers.QuestController;
import noppes.npcs.controllers.data.Availability;
import noppes.npcs.controllers.data.DialogCategory;
import noppes.npcs.controllers.data.DialogOption;
import noppes.npcs.controllers.data.FactionOptions;
import noppes.npcs.controllers.data.PlayerMail;
import noppes.npcs.controllers.data.Quest;
import noppes.npcs.util.ValueUtil;

public class Dialog
implements ICompatibilty,
IDialog {
    public Availability availability = new Availability();
    public DialogCategory category;
    public PlayerMail mail = new PlayerMail();
    public FactionOptions factionOptions = new FactionOptions();
    public final Map<Integer, DialogOption> options = new TreeMap<Integer, DialogOption>();
    public boolean disableEsc = false;
    public boolean hideNPC = false;
    public boolean showWheel = false;
    public int id = -1;
    public int quest = -1;
    public int version = VersionCompatibility.ModRev;
    public String command = "";
    public String sound;
    public String text = "";
    public String title = "";
    public boolean stopSound = true;
    public boolean showFits = true;
    public int delay = 0;
    public String texture = "";

    public Dialog(DialogCategory categoryIn) {
        this.category = categoryIn;
    }

    public Dialog copy() {
        Dialog dialog = new Dialog(this.category);
        NBTTagCompound compound = new NBTTagCompound();
        this.save(compound);
        dialog.load(compound);
        return dialog;
    }

    public Dialog copy(EntityPlayer player) {
        Dialog dialog = new Dialog(this.category);
        dialog.id = this.id;
        dialog.text = this.text;
        dialog.title = this.title;
        dialog.quest = this.quest;
        dialog.sound = this.sound;
        dialog.mail = this.mail;
        dialog.command = this.command;
        dialog.hideNPC = this.hideNPC;
        dialog.showWheel = this.showWheel;
        dialog.disableEsc = this.disableEsc;
        for (int slot : this.options.keySet()) {
            DialogOption option = this.options.get(slot);
            if (option.optionType == OptionType.DISABLED || player != null && !option.isAvailable(player) || option.optionType == OptionType.DIALOG_OPTION && !option.hasDialogs()) continue;
            dialog.options.put(slot, option);
        }
        dialog.stopSound = this.stopSound;
        dialog.showFits = this.showFits;
        dialog.delay = this.delay;
        dialog.texture = this.texture;
        return dialog;
    }

    @Override
    public IAvailability getAvailability() {
        return this.availability;
    }

    @Override
    public IDialogCategory getCategory() {
        return this.category;
    }

    @Override
    public String getCommand() {
        return this.command;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.title;
    }

    @Override
    public IDialogOption getOption(int slot) {
        IDialogOption option = this.options.get(slot);
        if (option == null) {
            throw new CustomNPCsException("There is no DialogOption for slot: " + slot, new Object[0]);
        }
        return option;
    }

    @Override
    public IDialogOption[] getOptions() {
        return this.options.values().toArray(new IDialogOption[0]);
    }

    @Override
    public Quest getQuest() {
        return QuestController.instance == null ? null : QuestController.instance.quests.get(this.quest);
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    public boolean notHasOtherOptions() {
        for (DialogOption option : this.options.values()) {
            if (option == null || option.optionType == OptionType.DISABLED) continue;
            return false;
        }
        return true;
    }

    public boolean hasQuest() {
        Quest questIn = this.getQuest();
        return questIn != null && questIn.isSetUp();
    }

    public void load(NBTTagCompound compound) {
        this.id = compound.func_74762_e("DialogId");
        this.loadPartial(compound);
    }

    public void loadPartial(NBTTagCompound compound) {
        this.version = compound.func_74762_e("ModRev");
        VersionCompatibility.CheckAvailabilityCompatibility(this, compound);
        this.title = compound.func_74779_i("DialogTitle");
        this.text = compound.func_74779_i("DialogText");
        this.quest = compound.func_74762_e("DialogQuest");
        this.sound = compound.func_74779_i("DialogSound");
        this.command = compound.func_74779_i("DialogCommand");
        this.mail.readNBT(compound.func_74775_l("DialogMail"));
        this.hideNPC = compound.func_74767_n("DialogHideNPC");
        this.showWheel = compound.func_74767_n("DialogShowWheel");
        this.disableEsc = compound.func_74767_n("DialogDisableEsc");
        NBTTagList list = compound.func_150295_c("Options", 10);
        this.options.clear();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound option = list.func_150305_b(i);
            int opSlot = option.func_74762_e("OptionSlot");
            DialogOption dia = new DialogOption();
            dia.load(option.func_74775_l("Option"));
            this.options.put(opSlot, dia);
            dia.slot = opSlot;
        }
        this.availability.load(compound);
        this.factionOptions.load(compound);
        if (compound.func_150297_b("DialogShowFits", 1)) {
            this.showFits = compound.func_74767_n("DialogShowFits");
        }
        if (compound.func_150297_b("DialogStopSound", 1)) {
            this.stopSound = compound.func_74767_n("DialogStopSound");
        }
        this.delay = ValueUtil.correctInt(compound.func_74762_e("ResponseDelay"), 0, 1200);
        this.texture = compound.func_74779_i("DialogTexture");
    }

    @Override
    public void save() {
        DialogController.instance.saveDialog(this.category, this);
    }

    @Override
    public void setCommand(String commandIn) {
        this.command = commandIn;
    }

    @Override
    public void setName(String name) {
        this.title = name;
    }

    @Override
    public void setQuest(IQuest questIn) {
        if (questIn == null) {
            this.quest = -1;
        } else {
            if (questIn.getId() < 0) {
                throw new CustomNPCsException("Quest id is lower than 0", new Object[0]);
            }
            this.quest = questIn.getId();
        }
    }

    @Override
    public void setText(String textIn) {
        this.text = textIn;
    }

    @Override
    public void setVersion(int versionIn) {
        this.version = versionIn;
    }

    @Override
    public NBTTagCompound save(NBTTagCompound compound) {
        compound.func_74768_a("DialogId", this.id);
        return this.saveToPartial(compound);
    }

    public NBTTagCompound saveToPartial(NBTTagCompound compound) {
        compound.func_74778_a("DialogTitle", this.title);
        compound.func_74778_a("DialogText", this.text);
        compound.func_74768_a("DialogQuest", this.quest);
        compound.func_74778_a("DialogCommand", this.command);
        compound.func_74782_a("DialogMail", (NBTBase)this.mail.writeNBT());
        compound.func_74757_a("DialogHideNPC", this.hideNPC);
        compound.func_74757_a("DialogShowWheel", this.showWheel);
        compound.func_74757_a("DialogDisableEsc", this.disableEsc);
        if (this.sound != null && !this.sound.isEmpty()) {
            compound.func_74778_a("DialogSound", this.sound);
        }
        NBTTagList list = new NBTTagList();
        for (int opSlot : this.options.keySet()) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74768_a("OptionSlot", opSlot);
            nbt.func_74782_a("Option", (NBTBase)this.options.get(opSlot).save());
            list.func_74742_a((NBTBase)nbt);
        }
        compound.func_74782_a("Options", (NBTBase)list);
        this.availability.save(compound);
        this.factionOptions.save(compound);
        compound.func_74768_a("ModRev", this.version);
        compound.func_74757_a("DialogStopSound", this.stopSound);
        compound.func_74757_a("DialogShowFits", this.showFits);
        compound.func_74768_a("ResponseDelay", this.delay);
        if (this.texture != null && !this.texture.isEmpty()) {
            compound.func_74778_a("DialogTexture", this.texture);
        }
        return compound;
    }

    public boolean hasDialogs(EntityPlayer player) {
        for (DialogOption option : this.options.values()) {
            if (option == null || option.optionType != OptionType.DIALOG_OPTION || !option.hasDialogs() || !option.isAvailable(player)) continue;
            return true;
        }
        return false;
    }

    public String getKey() {
        char c = '\u00a7';
        return c + "7ID:" + this.id + c + "8 " + this.category.title + "/" + c + "r" + this.title;
    }

    public void upPos(int optionId) {
        if (!this.options.containsKey(optionId) || optionId <= 0) {
            return;
        }
        TreeMap<Integer, DialogOption> newOptions = new TreeMap<Integer, DialogOption>();
        for (int id : this.options.keySet()) {
            DialogOption option = this.options.get(id);
            if (id == optionId - 1) {
                option.slot = id + 1;
                newOptions.put(id + 1, option);
                continue;
            }
            if (id == optionId) {
                option.slot = id - 1;
                newOptions.put(id - 1, option);
                continue;
            }
            newOptions.put(id, option);
        }
        this.options.clear();
        this.options.putAll(newOptions);
    }

    public void downPos(int optionId) {
        if (!this.options.containsKey(optionId) || optionId < 0 || optionId >= this.options.size() - 1) {
            return;
        }
        TreeMap<Integer, DialogOption> newOptions = new TreeMap<Integer, DialogOption>();
        for (int id : this.options.keySet()) {
            DialogOption option = this.options.get(id);
            if (id == optionId) {
                option.slot = id + 1;
                newOptions.put(id + 1, this.options.get(id));
                continue;
            }
            if (id == optionId + 1) {
                option.slot = id - 1;
                newOptions.put(id - 1, this.options.get(id));
                continue;
            }
            newOptions.put(id, this.options.get(id));
        }
        this.options.clear();
        this.options.putAll(newOptions);
    }
}

